/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.compat.ccl;

import codechicken.lib.render.block.BlockRenderingRegistry;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.nio.IntBuffer;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class CCLCompat {
    private static final boolean CCL_LOADED = Loader.isModLoaded((String)"codechickenlib");
    private static final ThreadLocal<BufferBuilder> CCL_BUILDERS = CCL_LOADED ? ThreadLocal.withInitial(() -> new BufferBuilder(204800)) : null;
    private static final VertexFormat FORMAT = DefaultVertexFormats.field_176600_a;
    private static final MethodHandle CCL_RENDER;

    public static boolean canHandle(EnumBlockRenderType type) {
        return CCL_LOADED && BlockRenderingRegistry.canHandle((EnumBlockRenderType)type);
    }

    private static void pumpIntoBuffer(BufferBuilder builder, ModelVertexSink sink) {
        IntBuffer theVertexData = builder.func_178966_f().asIntBuffer();
        int numQuads = theVertexData.limit() / FORMAT.func_181719_f();
        sink.ensureCapacity(numQuads);
        for (int i = 0; i < numQuads; ++i) {
            int vOff = i * FORMAT.func_181719_f();
            float x = Float.intBitsToFloat(theVertexData.get(vOff + 0));
            float y = Float.intBitsToFloat(theVertexData.get(vOff + 1));
            float z = Float.intBitsToFloat(theVertexData.get(vOff + 2));
            int color = theVertexData.get(vOff + 3);
            float u = Float.intBitsToFloat(theVertexData.get(vOff + 4));
            float v = Float.intBitsToFloat(theVertexData.get(vOff + 5));
            int light = theVertexData.get(vOff + 6);
            sink.writeQuad(x, y, z, color, u, v, light);
        }
        sink.flush();
    }

    public static void renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, ChunkModelBuffers buffers) {
        BufferBuilder builder = CCL_BUILDERS.get();
        builder.func_181668_a(7, FORMAT);
        builder.func_178969_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        try {
            boolean bl = CCL_RENDER.invokeExact(world, pos, state, builder);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            builder.func_178977_d();
        }
        CCLCompat.pumpIntoBuffer(builder, buffers.getSink(ModelQuadFacing.UNASSIGNED));
    }

    static {
        try {
            CCL_RENDER = CCL_LOADED ? MethodHandles.publicLookup().unreflect(ObfuscationReflectionHelper.findMethod(BlockRenderingRegistry.class, (String)"renderBlock", Void.TYPE, (Class[])new Class[]{IBlockAccess.class, BlockPos.class, IBlockState.class, BufferBuilder.class})) : null;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

